/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.food;

import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.food.Nutrient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class FoodData
implements INBTSerializable<NBTTagCompound> {
    public static final FoodData ROTTEN_FLESH = new FoodData(0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Float.POSITIVE_INFINITY);
    public static final FoodData GOLDEN_APPLE = new FoodData(1, 0.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final FoodData GOLDEN_CARROT = new FoodData(1, 0.0f, 0.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.0f, 0.0f);
    public static final FoodData RAW_EGG = new FoodData(1, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.3f);
    public static final FoodData MILK = new FoodData(0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
    private final float[] nutrients;
    private int hunger;
    private float saturation;
    private float water;
    private float decayModifier;
    private boolean buffed;

    public FoodData() {
        this(4, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public FoodData(int hunger, float water, float saturation, float grain, float fruit, float veg, float protein, float dairy, float decayModifier) {
        this(hunger, water, saturation, new float[]{grain, fruit, veg, protein, dairy}, decayModifier);
    }

    public FoodData(int hunger, float water, float saturation, float[] nutrients, float decayModifier) {
        this.hunger = hunger;
        this.water = water;
        this.saturation = saturation;
        this.nutrients = nutrients;
        this.decayModifier = decayModifier;
    }

    public FoodData(@Nullable NBTTagCompound nbt) {
        this.nutrients = new float[5];
        this.deserializeNBT(nbt);
    }

    public float[] getNutrients() {
        return this.nutrients;
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public float getWater() {
        return this.water;
    }

    public float getDecayModifier() {
        return this.decayModifier;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("food", this.hunger);
        nbt.func_74776_a("sat", this.saturation);
        nbt.func_74776_a("water", this.water);
        nbt.func_74776_a("decay", this.decayModifier);
        nbt.func_74776_a("grain", this.nutrients[Nutrient.GRAIN.ordinal()]);
        nbt.func_74776_a("veg", this.nutrients[Nutrient.VEGETABLES.ordinal()]);
        nbt.func_74776_a("fruit", this.nutrients[Nutrient.FRUIT.ordinal()]);
        nbt.func_74776_a("meat", this.nutrients[Nutrient.PROTEIN.ordinal()]);
        nbt.func_74776_a("dairy", this.nutrients[Nutrient.DAIRY.ordinal()]);
        nbt.func_74757_a("buffed", this.buffed);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            this.hunger = nbt.func_74762_e("food");
            this.saturation = nbt.func_74760_g("sat");
            this.water = nbt.func_74760_g("water");
            this.decayModifier = nbt.func_74760_g("decay");
            this.nutrients[Nutrient.GRAIN.ordinal()] = nbt.func_74760_g("grain");
            this.nutrients[Nutrient.VEGETABLES.ordinal()] = nbt.func_74760_g("veg");
            this.nutrients[Nutrient.FRUIT.ordinal()] = nbt.func_74760_g("fruit");
            this.nutrients[Nutrient.PROTEIN.ordinal()] = nbt.func_74760_g("meat");
            this.nutrients[Nutrient.DAIRY.ordinal()] = nbt.func_74760_g("dairy");
            this.buffed = nbt.func_74767_n("buffed");
        }
    }

    public FoodData copy() {
        return new FoodData(this.hunger, this.water, this.saturation, this.nutrients, this.decayModifier);
    }

    public void applyBuff(FoodData buff) {
        if (!this.buffed) {
            this.buffed = true;
            for (Nutrient nutrient : Nutrient.values()) {
                int n = nutrient.ordinal();
                this.nutrients[n] = this.nutrients[n] + buff.nutrients[nutrient.ordinal()];
            }
        }
    }
}

